// ==UserScript==
// @name         5ch Imgur拡張子付きURLへ自動変換（画像/動画 + 省略URL対応）
// @namespace    http://tampermonkey.net/
// @version      1.4
// @description  imgur.comの省略リンクを動的に検出し、画像・動画の直リンクへ変換（https省略含む）、リンクテキストは変更しない
// @author       OpenAI
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// ==/UserScript==

(function () {
    'use strict';

    const extensions = [
        '.jpg', '.jpeg', '.png', '.gif', '.apng',
        '.tiff', '.tif', '.bmp',
        '.mp4', '.mov', '.webm'
    ];

    const imgurLinkRegex = /(?:https?:)?(?:\/\/)?(?:www\.)?imgur\.com\/([a-zA-Z0-9]+)(?!\.\w+)/;

    const processedLinks = new WeakSet();

    async function checkAndReplaceImgurLink(a) {
        if (processedLinks.has(a)) return;
        processedLinks.add(a);

        const href = a.getAttribute('href');
        if (!href) return;

        // 拡張子付きURLは除外
        if (/\.[a-zA-Z0-9]{2,4}$/.test(href)) {
            return;
        }
        // idの後にドットがあるURLは除外（例: imgur.com/abc123.）
        if (/imgur\.com\/[a-zA-Z0-9]+\./.test(href)) {
            return;
        }

        const match = href.match(imgurLinkRegex);
        if (!match) return;

        const id = match[1];
        const baseUrl = `https://i.imgur.com/${id}`;

        for (const ext of extensions) {
            try {
                const res = await fetch(baseUrl + ext, { method: 'HEAD' });
                if (res.ok) {
                    // hrefだけ書き換え。テキストは触らない
                    a.setAttribute('href', baseUrl + ext);
                    break;
                }
            } catch {
                // 無視して次へ
            }
        }
    }

    function processLinks() {
        const links = document.querySelectorAll('a[href*="imgur.com"]');
        for (const a of links) {
            checkAndReplaceImgurLink(a);
        }
    }

    window.addEventListener('load', processLinks);

    let debounceTimer;
    const observer = new MutationObserver(() => {
        clearTimeout(debounceTimer);
        debounceTimer = setTimeout(() => {
            processLinks();
        }, 300);
    });

    observer.observe(document.body, { childList: true, subtree: true });

})();
